/**
 * Created by lei.wang_1 on 2016/8/8.
 */
appModule.directive("noticeProgressBar", ["$translate",function (translate) {
    return {
        template: '<div class="rect progress"><div class="progressWrapper"><span></span><div class="percentText"></div></div></div></div><div class="circleProgress_wrapper circle"><div class="wrappers right"><div class="circleProgress rightcircle"></div></div><div class="wrappers left"><div class="circleProgress leftcircle"></div></div></div>',
        restrict: 'E',
        scope: {
            progress:'=',
            type:'@'
        },
        link: function ($scope, element) {
            element.addClass($scope.barCss);
            if($scope.type=='circle'){
                element.find('.rect').hide();
            }else{
                element.find('.circle').hide();
            }

            var stopWatchProgress = $scope.$watch('progress',function(newV,oldV){
                if(newV){
                    newV = newV > 100 ? 100 : newV;
                    if($scope.type=='circle'){
                        calcPercentage(newV);
                    }else{
                        var value = newV+'%';
                        element.find('span').css('width',value);
                        element.find('.percentText').text(value);
                    }

                }else{
                    element.find('.percentText').text(translate.instant('common.waiting'));
                }
            });

            function calcPercentage(num){
                if(num < 0 || num > 100){
                    return;
                }
                var deg = parseInt(360 * (num/100));
                if(deg <= 180){
                    deg = -135 + deg;
                    element.find('.rightcircle').css('transform', 'rotate('+deg+'deg)');
                    element.find('.leftcircle')[0].style.transform = 'rotate(-135deg)';
                }else{
                    deg = -135 + (deg - 180);
                    element.find('.rightcircle').css('transform','rotate(45deg)');
                    element.find('.leftcircle').css('transform', 'rotate('+deg+'deg)');
                }
            }

            $scope.$on('$destroy',function(){
                stopWatchProgress();
            });
        }
    };
}]);